#!/usr/bin/env python3
import numpy as np, pandas as pd
from astropy.io import fits

def pick(names, options):
    for o in options:
        if o in names: return o
    return None

def main():
    L = pd.read_csv("data/lenses.csv")
    h=fits.open("data/KiDS_DR4_brightsample.fits", memmap=True)
    D=h[1].data; names=list(h[1].columns.names)
    ra_c=pick(names, ["RAJ2000","ALPHA_J2000","RA","ALPHAWIN_J2000"])
    de_c=pick(names, ["DECJ2000","DELTA_J2000","DEC","DELTAWIN_J2000"])
    rb = pd.DataFrame({"ra_deg":D[ra_c].astype(float), "dec_deg":D[de_c].astype(float)}).dropna()

    rng = np.random.default_rng(42)
    out = []
    for (rg,ms), G in L.groupby(["R_G_bin","Mstar_bin"]):
        idx = rng.choice(len(rb), size=len(G), replace=False)
        S = rb.iloc[idx].copy()
        S["z_lens"] = G["z_lens"].sample(n=len(G), random_state=42, replace=True).to_numpy()
        S["R_G_kpc"] = G["R_G_kpc"].sample(n=len(G), random_state=7, replace=True).to_numpy()
        S["Mstar_log10"] = G["Mstar_log10"].sample(n=len(G), random_state=9, replace=True).to_numpy()
        S["R_G_bin"] = rg; S["Mstar_bin"]=ms
        S["id"] = [f"RAND_{rg}_{ms}_{i:06d}" for i in range(len(S))]
        out.append(S[["id","ra_deg","dec_deg","z_lens","R_G_kpc","Mstar_log10","R_G_bin","Mstar_bin"]])
    R = pd.concat(out, ignore_index=True)
    R.to_csv("data/lenses_random.csv", index=False)
    print("Wrote data/lenses_random.csv:", len(R))
if __name__ == "__main__":
    main()
